#### Figure 2 - Source code 1

import pandas as pd
import matplotlib.pyplot as plt
import numpy as np
import matplotlib as mpl

mpl.rcParams['font.size'] = 12
mpl.rcParams['text.usetex'] = False
mpl.rcParams['text.latex.preamble'] = r'\usepackage{{amsmath}}'

grid = plt.GridSpec(4, 3, wspace=0.55, hspace=1.35)
plt.figure(figsize = (9, 5))

ax1 = plt.subplot(grid[0:2,0])
data_ra = pd.read_csv("reduccion_alpha_hh.csv")
data_ra_over = data_ra[data_ra["case"] == "Overshoot"]
data_ra_ss = data_ra[data_ra["case"] == "Steady-state"]

plt.plot([1,2,3,4,5], data_ra_over["dif"], "r.")
plt.plot([1,2,3,4,5], data_ra_ss["dif"], ".", c ="lime")
plt.ylabel(r"$\Delta x \ (\mu m)$")
plt.xticks([1,2,3,4,5], ["1/2", "3/4", "1", "4/3", "2"])
plt.xlabel(r"perturbation in $\alpha_{Hh} \ (\times \alpha_{Hh_0}) $")
plt.ylim(-0.6, 11)


ax2 = plt.subplot(grid[0:2,1])
data = pd.read_csv(r"variaciones_todos_params.csv")
dif_over = data["x_over1"] - data["x_over05"]
dif_ss = data["x_ss1"] - data["x_ss05"]

plt.plot([i for i in range(len(dif_over))], dif_over, "r.")
plt.plot([i for i in range(len(dif_over))], dif_ss, ".", c ="lime")

plt.ylabel("$\Delta x \ (\mu m)$", fontsize = 12)
plt.xlabel("code runs")
plt.ylim(0,15)

ax3 = plt.subplot(grid[2:4, 0])
data_alpha_ptc = pd.read_csv("variacion_alpha_ptc.csv")
aptcby = np.array([0, 0.2, 0.4, 0.6, 0.8, 1])
plt.plot(aptcby, data_alpha_ptc[data_alpha_ptc["case"] == "Overshoot"]["Delta x"], "r.")
plt.plot(aptcby, data_alpha_ptc[data_alpha_ptc["case"] == "Steady State"]["Delta x"], ".", c ="lime")

plt.ylabel(r"$\Delta x  \  (\mu m)$")
plt.xlabel(r"perturbation in $\alpha_{ptc} \ (\times \alpha_{ptc_0})$")
plt.ylim(0,10)


ax4 = plt.subplot(grid[2:4,1])
data4 = pd.read_csv("Figure 2 - Source data 4.csv")

dif_over = data4["dif_over"]
dif_ss = data4["dif_ss"]

plt.plot([i for i in range(len(dif_over))], dif_over, "o", mfc = "none", c = "green", label = r"$\alpha_{ptc}$ = 0")
plt.plot([i for i in range(len(dif_over))], dif_ss,".", c ="lime", label = r"$\alpha_{ptc}$")

plt.ylabel("$\Delta x \ (\mu m)$", fontsize = 12)
plt.xlabel("code runs")

plt.ylim(0,15)
plt.legend(fontsize = 8, loc = "lower right")


ax5 = plt.subplot(grid[1:3,2])
deltax = np.load("deltaX_all_transient_states.npy")

t = np.linspace(0, 8, len(deltax[0:28800]))
plt.plot([i for i in range(len(deltax[0:28800]))], deltax[0:28800], "k")
plt.plot([5900, 5900], [0,7.8], "r")
plt.plot([28700, 28700], [0,6.6], "g")
plt.text(4000, 8.4, "dpp")
plt.text(25500, 7, "col")
plt.ylabel("$\Delta x \ (\mu m)$")
plt.xlabel("time (h)")
plt.xticks([i for i in range(0, len(deltax[0:28800]), len(deltax[0:28800])//4)], [0,1,2,3])
plt.ylim(0, 10)


plt.text(-113000,18, "a", fontsize=14,  weight='bold')
plt.text(-60000,18, "a'", fontsize=14,  weight='bold')
plt.text(-113000,4.2, "b", fontsize=14,  weight='bold')
plt.text(-60000,4.2, "b'", fontsize=14,  weight='bold')
plt.text(-8000,11.5, "c", fontsize=14,  weight='bold')


plt.show()